package edu.cmu.cs.cs214.exceptions;

import java.io.*;

public class ReadBowlingScore {
	
	static int getIntFromFile(String filename) {
		int i= -1;
		try {
			FileInputStream fileInput = new FileInputStream(filename);
			DataInput dataInput = new DataInputStream(fileInput);
			i= dataInput.readInt();
			fileInput.close();
		} catch (FileNotFoundException e) {
			System.out.println("Could not open file " + filename);
		} catch (IOException e) {
			System.out.println("Could not read int from file " + filename);
		}
		return i;  // Warning!  Returning -1 in the case of the above errors is bad design
		           // and will cause easily-created bugs.  Do not try this at home.
	}

	static int readBowlingScore(String filename) throws IllegalBowlingScoreException {
		int score = getIntFromFile(filename);
		if (score < 0 || score > 300) {
			throw new IllegalBowlingScoreException("readIntFromFile returned " + 
					                           String.valueOf(score));
		}
		return score;
	}
	
	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) {
		String fileName = "badFile.txt";
		try {
			int i = readBowlingScore(fileName);
			System.out.println("read " + i + " from file " + fileName);
		} catch (IllegalBowlingScoreException e) {
			System.out.println("Could not read a valid bowling score from file " + fileName + 
					           ":  " + e.getMessage());
		}
	}

}
